float4x4 g_light_view_projection_matrix		: WORLDVIEWPROJ;	
float4x4 g_world_matrix				: WORLD;		

//VERTEX SHADER
void ShadowMapVS(float3 posL : POSITION0, out float4 posH : POSITION0, out float2 depth : TEXCOORD0) 
{
	posH = mul(float4(posL, 1.0f), g_world_matrix);
	posH = mul(posH, g_light_view_projection_matrix);
	depth = posH.zw;
}

//PIXEL SHADER
float4 ShadowMapPS(float2 depth : TEXCOORD0) : COLOR
{
	return depth.x / depth.y;
}

technique Basic
{
    pass P0
    {
        VertexShader		= compile vs_3_0 ShadowMapVS();
        PixelShader		= compile ps_2_0 ShadowMapPS();
    }
}
 
